 ; Ŀ
 ;   Strafe - break up a text string around its spaces.                    
 ;   Copyright 1995, 2001, 2006 by Rocket Software Ltd.                    
 ;   Dedicated to the brotherhood of walrus ranchers.                      
 ; 

 ; Ŀ
 ;   MtStr - see if a string contains only spaces.                         
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   Arguments: Str, the string.                                           
 ;   Returns T if the string was spaces only, otherwise Nil.               
 ; 
 (DEFUN MTSTR (strp)
  (while (and (/= strp "") (= (substr strp 1 1) " "))
         (setq strp (substr strp 2)))
  (if (= strp "") T ()))
 ; Ŀ
 ;   MtStr end.                                                            
 ; 

 ; Ŀ
 ;   Scop - copy a text entity, install a string, move it to a point.      
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   Arguments: Enam, the text entity name.                                
 ;              Str, the string.                                           
 ;              Pa, the point.                                             
 ;   Calls nothing, returns some very late library books.                  
 ; 
 (DEFUN SCOP (enam str pa / entt ten)
  (command ".copy" enam "" "0,0" "0,0")
  (setq entt (entget (setq enam (entlast))))
  (setq entt (subst (cons 1 str) (assoc 1 entt) entt))
  (entmod entt)                                            ; go
  (setq entt (entget enam))
  (setq ten (cdr (assoc 10 entt)))
  (command ".move" enam "" ten pa)
 (princ))
 ; Ŀ
 ;   Scop end.                                                             
 ; 

 ; Ŀ
 ;   Rile - find the width of a text entity by converting it to right      
 ;   justification and measuring the distance between its ten and eleven   
 ;   points.                                                               
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;   Arguments: Str - the string to measure.                               
 ;              Enam - the ename of an entity having the properties        
 ;              which we require in the string.                            
 ;   Calls nothing, returns a distance.                                    
 ;   Not as simple as the textbox function, but doesn't return zero as     
 ;   the width of a space, which textbox now does - this must be a new     
 ;   paradigm or something.                                                
 ;   This returns a length of zero for an empty string, by the way.        
 ; 
 (DEFUN RILE (str enam / entt typp dist)
  (setq entt (entget enam))
  (if (member (setq typp (cdr (assoc 0 entt))) '("TEXT" "ATTDEF"))
      (progn
           (command ".copy" enam "" "0,0" "0,0")
           (setq entt (entget (setq enam (entlast))))
           (if (= typp "TEXT")
               (setq entt (subst (cons 1 str) (assoc 1 entt) entt))
               (setq entt (subst (cons 2 str) (assoc 2 entt) entt)))
           (entmod (subst (cons 72 2) (assoc 72 entt) entt))    ; change
           (setq entt (entget enam))                 ; get the changed edata
           (setq dist (distance (cdr (assoc 10 entt)) (cdr (assoc 11 entt))))
           (entdel enam)))
 dist)
 ; Ŀ
 ;   Rile end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Strlst - break a text string up into a list of substrings  
 ;   divided at occurrences of a given number of spaces.                   
 ;   Takes two arguments, the string and the number of spaces.             
 ;   Returns the original string decomposed into a list of strings          
 ;   alternating between text and spaces.                                  
 ; 
 (DEFUN STRLST (str spnum / spcstr num perf strlis len pos subs)
  (setq spcstr "")
  (repeat spnum (setq spcstr (strcat spcstr " ")))
  (setq num 0)
  (while (= (substr str 1 1) " ")
         (if (null perf) (setq perf ""))
         (setq perf (strcat perf " "))
         (setq str (substr str 2)))
  (if perf (setq strlis (append strlis (list perf))))
  (setq len (strlen str))
  (setq pos 1)
  (while (<= pos len)
         (setq subs (substr str pos spnum))
         (if (= subs spcstr)
             (progn
                  (setq strlis (append strlis (list (substr str 1 (1- pos)))))
                  (setq str (substr str pos))
                  (setq perf ())
                  (while (= (substr str 1 1) " ")
                         (if (null perf) (setq perf ""))
                         (setq perf (strcat perf " "))
                         (setq str (substr str 2)))
                  (if perf (setq strlis (append strlis (list perf))))
                  (setq pos 1))
             (setq pos (1+ pos))))
  (setq perf ())
  (while (= (substr str 1 (setq len (strlen str))) " ")
         (if (null perf) (setq perf ""))
         (setq perf (strcat perf " "))
         (setq str (substr str 1 (1- len))))
  (if (/= str "")
      (setq strlis (append strlis (list str))))
  (if perf (setq strlis (append strlis (list perf))))
 strlis)
 ; Ŀ
 ;   Strlst end.                                                           
 ; 

 ; Ŀ
 ;   Strafe - a deceptively dangerous routine.                             
 ; 
 (DEFUN C:STRAFE (/ ss spnum spnump num enam tent str pll rota strlis allstr
                                                                  nexstr pos)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get the text entities to process.                                     
 ; 
  (setq ss (ssget (list (cons 0 "TEXT"))))
 ; Ŀ
 ;   Get the number of spaces to break at.                                 
 ; 
  (if (or (/= (type spnum) 'INT)
          (= spnum 0))
      (setq spnum 3))
  (initget 6)
  (setq spnump (getint (strcat "Break on <" (itoa spnum) "> spaces: ")))
  (if spnump (setq spnum spnump))
 ; Ŀ
 ;   Process the selection set.                                            
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq tent (entget enam))
         (setq str (cdr (assoc 1 tent)))
         (setq pll (cdr (assoc 10 tent)))
         (setq rota (cdr (assoc 50 tent)))
         (setq strlis (strlst str spnum))
         (setq allstr "")
         (while (setq nexstr (car strlis))
                (setq strlis (cdr strlis))
 ; Ŀ
 ;   Get the next lower left point.                                        
 ; 
                (setq pos (polar pll rota (rile allstr enam)))
 ; Ŀ
 ;   Make the new text entity, install the string, put it at the point.    
 ; 
                (if (not (mtstr nexstr)) (scop enam nexstr pos))
                (setq allstr (strcat allstr nexstr))))
  (if ss (command "erase" ss ""))
 (princ))